#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

try:
    load_translations()
except NameError:
    pass

__license__   = 'GPL v3'
__copyright__ = '2026, Dunhill'
__docformat__ = 'restructuredtext en'

from qt.core import QWidget, QVBoxLayout, QLabel, QLineEdit
from calibre.utils.config import JSONConfig

prefs = JSONConfig('plugins/palette_switcher')

prefs.defaults['palettes_subdir'] = 'palettes'
prefs.defaults['last_palette'] = None
prefs.defaults['auto_apply_on_start'] = True

class ConfigWidget(QWidget):

    def __init__(self):
        QWidget.__init__(self)
        self.l = QVBoxLayout()
        self.setLayout(self.l)

        self.label = QLabel(_('Palettes Subdirectory (relative to config dir)'))
        self.l.addWidget(self.label)

        self.msg = QLineEdit(self)
        self.msg.setText(prefs['palettes_subdir'])
        self.l.addWidget(self.msg)
        self.label.setBuddy(self.msg)

    def save_settings(self):
        prefs['palettes_subdir'] = self.msg.text()
