#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

__license__   = 'GPL v3'
__copyright__ = '2026, Dunhill'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

class PaletteSwitcher(InterfaceActionBase):
    name                = 'Palette Switcher'
    description         = 'Allows you to select and apply color palettes (.calibre.palette) from the Calibre configuration folde'
    supported_platforms = ['windows', 'osx', 'linux']
    author              = 'Dunhill & Comfy.n'
    version             = (1, 0, 400)
    minimum_calibre_version = (6, 0, 0)

    actual_plugin       = 'calibre_plugins.palette_switcher.ui:InterfacePlugin'

    def is_customizable(self):
        return True

    def config_widget(self):
        from calibre_plugins.palette_switcher.config import ConfigWidget
        return ConfigWidget()

    def save_settings(self, config_widget):
        config_widget.save_settings()
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()
