__license__   = 'GPL v3'
__copyright__ = '2026, Comfy.n'
__docformat__ = 'restructuredtext en'

try:
    load_translations()
except NameError:
    pass

from qt.core import Qt, QWidget, QVBoxLayout, QLabel, QLineEdit, QHBoxLayout, QToolButton, QTreeView, QStandardItemModel, QAbstractItemView, QSizePolicy, QComboBox, QPushButton
from calibre_plugins.rss_reader.history_dropdown import HistoryDropdown
from calibre_plugins.rss_reader.common_icons import get_icon
from calibre_plugins.rss_reader import rss_db

# Import debug helper for folder drag/drop signals
from calibre_plugins.rss_reader.debug import _debug

# Robust Qt UserRole constant for item data
try:
    ROLE_USER = getattr(getattr(Qt, 'ItemDataRole', None), 'UserRole', getattr(Qt, 'UserRole', 32))
except Exception:
    ROLE_USER = 32

def build_feeds_panel(self, central_widget):
    left_panel = QWidget(central_widget)
    try:
        left_panel.setMinimumWidth(150)
    except Exception:
        pass
    left_layout = QVBoxLayout(left_panel)
    left_layout.setContentsMargins(0, 0, 0, 0)

    # Feeds label with count
    self.feeds_label = QLabel('', left_panel)
    try:
        self.feeds_label.setStyleSheet('padding-left: 10px;')
    except Exception:
        pass
    left_layout.addWidget(self.feeds_label)
    try:
        self._update_feeds_label()
    except Exception:
        pass

    self.feeds_filter_input = QLineEdit(left_panel)
    self.feeds_filter_input.setPlaceholderText(_('Filter feeds...'))
    try:
        self.feeds_filter_input.setToolTip(
            _('Filters by feed title/URL. For feed specs (ATOM/RSS, encoding, version), use the Advanced search box below, e.g. type:atom, encoding:utf-8, version:2.0')
        )
    except Exception:
        pass
    try:
        self.feeds_filter_input.setClearButtonEnabled(True)
    except Exception:
        pass
    try:
        self.feeds_filter_input.setMinimumWidth(60)
        self.feeds_filter_input.setSizePolicy(QSizePolicy.Policy.Ignored, QSizePolicy.Policy.Fixed)
    except Exception:
        try:
            self.feeds_filter_input.setMinimumWidth(50)
            self.feeds_filter_input.setSizePolicy(QSizePolicy.Ignored, QSizePolicy.Fixed)
        except Exception:
            pass
    self.feeds_filter_input.textChanged.connect(self.filter_feeds_tree)
    left_layout.addWidget(self.feeds_filter_input)

    # Quick tree actions (add folder / expand / collapse)
    try:
        tree_actions = QWidget(left_panel)
        tree_actions_lay = QHBoxLayout(tree_actions)
        tree_actions_lay.setContentsMargins(6, 0, 6, 0)
        try:
            tree_actions_lay.setSpacing(4)
        except Exception:
            pass

        def _persist_expanded_folders(expand_all=False):
            try:
                if expand_all:
                    folders = list(rss_db.get_folders() or [])
                    gprefs['rss_reader_expanded_folders'] = [str(x).strip().strip('/') for x in folders if str(x).strip()]
                else:
                    gprefs['rss_reader_expanded_folders'] = []
            except Exception:
                pass

        self.feeds_add_folder_btn = QToolButton(tree_actions)
        _add_folder_text = _('Add folder')
        self.feeds_add_folder_btn.setText(_add_folder_text)
        try:
            ic = None
            try:
                ic = QIcon.ic('tb_folder.png')
            except Exception:
                ic = None
            if ic is not None and not ic.isNull():
                self.feeds_add_folder_btn.setIcon(ic)
            else:
                try:
                    self.feeds_add_folder_btn.setText('📁 ' + (_add_folder_text if '_add_folder_text' in locals() else _('Add folder')))
                except Exception:
                    pass
        except Exception:
            pass
        try:
            self.feeds_add_folder_btn.setToolButtonStyle(Qt.ToolButtonStyle.ToolButtonTextBesideIcon)
        except Exception:
            try:
                self.feeds_add_folder_btn.setToolButtonStyle(Qt.ToolButtonTextBesideIcon)
            except Exception:
                pass
        self.feeds_add_folder_btn.setToolTip(_('Add a folder at the root'))
        self.feeds_add_folder_btn.clicked.connect(lambda: self.add_folder(''))
        tree_actions_lay.addWidget(self.feeds_add_folder_btn)

        self.feeds_expand_all_btn = QToolButton(tree_actions)
        try:
            self.feeds_expand_all_btn.setText('▾')
        except Exception:
            try:
                self.feeds_expand_all_btn.setText('v')
            except Exception:
                self.feeds_expand_all_btn.setText(_('Expand'))
        self.feeds_expand_all_btn.setToolTip(_('Expand all folders'))
        self.feeds_expand_all_btn.clicked.connect(lambda: (self.feeds_tree.expandAll(), _persist_expanded_folders(True)))
        tree_actions_lay.addWidget(self.feeds_expand_all_btn)

        self.feeds_collapse_all_btn = QToolButton(tree_actions)
        try:
            self.feeds_collapse_all_btn.setText('▸')
        except Exception:
            try:
                self.feeds_collapse_all_btn.setText('>')
            except Exception:
                self.feeds_collapse_all_btn.setText(_('Collapse'))
        self.feeds_collapse_all_btn.setToolTip(_('Collapse all folders'))
        def _collapse_all_keep_root():
            try:
                self.feeds_tree.collapseAll()
            except Exception:
                pass
            _persist_expanded_folders(False)
            try:
                m = self.feeds_tree.model()
                r = m.invisibleRootItem()
                if r is not None and r.rowCount() == 1:
                    it = r.child(0)
                    d = it.data(ROLE_USER)
                    if isinstance(d, dict) and d.get('type') == 'root':
                        self.feeds_tree.setExpanded(m.indexFromItem(it), True)
            except Exception:
                pass
        self.feeds_collapse_all_btn.clicked.connect(_collapse_all_keep_root)
        tree_actions_lay.addWidget(self.feeds_collapse_all_btn)

        tree_actions_lay.addStretch(1)
        left_layout.addWidget(tree_actions)
    except Exception:
        pass

    self.feeds_tree = QTreeView(left_panel)
    self.feeds_tree.setHeaderHidden(True)
    try:
        self.feeds_tree.setIndentation(18)
        self.feeds_tree.setStyleSheet('''
            QTreeView::item {
                padding: 2px 0px;
            }
            QTreeView::branch {
                padding: 2px 0px;
            }
        ''')
    except Exception:
        pass
    try:
        self.feeds_tree.setSelectionMode(QAbstractItemView.SelectionMode.ExtendedSelection)
    except Exception:
        try:
            self.feeds_tree.setSelectionMode(QAbstractItemView.ExtendedSelection)
        except Exception:
            pass
    self.feeds_tree.setModel(QStandardItemModel())

    try:
        self.feeds_tree.setDragDropMode(QAbstractItemView.DragDropMode.InternalMove)
    except Exception:
        try:
            self.feeds_tree.setDragDropMode(QAbstractItemView.InternalMove)
        except Exception:
            pass
    try:
        self.feeds_tree.setDragEnabled(True)
        self.feeds_tree.setAcceptDrops(True)
        self.feeds_tree.setDropIndicatorShown(True)
    except Exception:
        pass
    try:
        self.feeds_tree.setDefaultDropAction(Qt.DropAction.MoveAction)
    except Exception:
        try:
            self.feeds_tree.setDefaultDropAction(Qt.MoveAction)
        except Exception:
            pass

    # Persist reorders/moves after an InternalMove completes.
    try:
        self._persist_tree_scheduled = False
    except Exception:
        pass
    try:
        m0 = self.feeds_tree.model()
        if m0 is not None:
            if hasattr(m0, 'rowsMoved'):
                m0.rowsMoved.connect(lambda *a, **k: (
                    _debug('[FOLDER] rowsMoved signal fired!'),
                    self._schedule_persist_feeds_tree()
                ))
            if hasattr(m0, 'rowsInserted'):
                m0.rowsInserted.connect(lambda *a, **k: (
                    _debug('[FOLDER] rowsInserted signal fired'),
                    self._schedule_persist_feeds_tree() if not getattr(self, '_refreshing_feeds_tree', False) else None
                ))
            if hasattr(m0, 'rowsRemoved'):
                m0.rowsRemoved.connect(lambda *a, **k: (
                    _debug('[FOLDER] rowsRemoved signal fired'),
                    self._schedule_persist_feeds_tree() if not getattr(self, '_refreshing_feeds_tree', False) else None
                ))
    except Exception:
        pass
    try:
        self.feeds_tree.selectionModel().selectionChanged.connect(self.on_feed_selected)
        self.feeds_tree.selectionModel().selectionChanged.connect(self._update_export_btn_tooltip)
        self.feeds_tree.selectionModel().selectionChanged.connect(self._update_current_feed_label)
        self.feeds_tree.selectionModel().selectionChanged.connect(self._update_feeds_label)
        self.feeds_tree.selectionModel().selectionChanged.connect(self.update_toolbar_button_states)
    except Exception:
        pass
    try:
        self.feeds_tree.clicked.connect(self._on_feed_tree_item_pressed)
    except Exception:
        pass
    self.feeds_tree.setContextMenuPolicy(Qt.ContextMenuPolicy.CustomContextMenu)
    self.feeds_tree.customContextMenuRequested.connect(self.on_feeds_context_menu)

    try:
        self._autoscroll_filter = _CtrlMiddleAutoscroll(self)
        self.feeds_tree.installEventFilter(self._autoscroll_filter)
    except Exception:
        pass
    left_layout.addWidget(self.feeds_tree)

    # Feed filters (by feed-level star, item heuristics, and user tags)
    try:
        tag_box = QWidget(left_panel)
        tag_vlayout = QVBoxLayout(tag_box)
        tag_vlayout.setContentsMargins(2, 2, 2, 2)
        try:
            tag_vlayout.setSpacing(3)
        except Exception:
            pass

        top_row = QWidget(tag_box)
        tag_layout = QHBoxLayout(top_row)
        tag_layout.setContentsMargins(0, 0, 0, 0)
        try:
            tag_layout.setSpacing(3)
        except Exception:
            pass

        tag_layout.addWidget(QLabel(_('Tag filter:'), top_row))

        self.feed_tag_filter_combo = QComboBox(top_row)
        self.feed_tag_filter_combo.setToolTip(_('Tag filter: ★ starred feeds, img, audio, long, or a feed tag (manual or auto).'))
        try:
            self.feed_tag_filter_combo.setMinimumWidth(81)
            self.feed_tag_filter_combo.setSizePolicy(QSizePolicy.Policy.Minimum, QSizePolicy.Policy.Fixed)
            try:
                self.feed_tag_filter_combo.setMinimumContentsLength(1)
            except Exception:
                pass
            try:
                self.feed_tag_filter_combo.setSizeAdjustPolicy(QComboBox.SizeAdjustPolicy.AdjustToMinimumContentsLengthWithIcon)
            except Exception:
                pass
        except Exception:
            pass
        self.feed_tag_filter_combo.setEnabled(True)
        tag_layout.addWidget(self.feed_tag_filter_combo)
        try:
            self._refresh_feed_tag_dropdown()
        except Exception:
            pass
        try:
            self.feed_tag_filter_combo.currentIndexChanged[int].connect(self._on_feed_tag_combo_changed)
        except Exception:
            try:
                self.feed_tag_filter_combo.currentIndexChanged.connect(self._on_feed_tag_combo_changed)
            except Exception:
                pass
        try:
            self.feed_tag_filter_combo.activated[int].connect(self._on_feed_tag_combo_changed)
        except Exception:
            pass

        self.tag_clear_btn = QPushButton(_('×'), top_row)
        self.tag_clear_btn.setToolTip(_('Clear tag filter'))
        try:
            self.tag_clear_btn.setFixedWidth(24)
            self.tag_clear_btn.setFlat(True)
        except Exception:
            try:
                self.tag_clear_btn.setMaximumWidth(24)
            except Exception:
                pass
        try:
            self.tag_clear_btn.setStyleSheet('''
                QPushButton {
                    padding: 2px 4px;
                    border: 1px solid #555;
                    border-radius: 3px;
                    background: #2f2f2f;
                    color: #e8e8e8;
                    font-weight: bold;
                }
                QPushButton:hover {
                    background: #3a3a3a;
                    color: #ffffff;
                }
            ''')
        except Exception:
            pass
        self.tag_clear_btn.clicked.connect(self._clear_feed_tag_filters)
        tag_layout.addWidget(self.tag_clear_btn)

        try:
            tag_layout.addStretch(1)
        except Exception:
            pass

        self.feeds_stats_label = QLabel('', top_row)
        self.feeds_stats_label.setStyleSheet('color: gray; font-size: 9pt;')
        try:
            self.feeds_stats_label.setAlignment(Qt.AlignmentFlag.AlignRight | Qt.AlignmentFlag.AlignVCenter)
        except Exception:
            try:
                self.feeds_stats_label.setAlignment(Qt.AlignRight | Qt.AlignVCenter)
            except Exception:
                pass
        try:
            self.feeds_stats_label.setMinimumWidth(0)
        except Exception:
            pass
        try:
            self.feeds_stats_label.setSizePolicy(QSizePolicy.Policy.Ignored, QSizePolicy.Policy.Fixed)
        except Exception:
            try:
                self.feeds_stats_label.setSizePolicy(QSizePolicy.Ignored, QSizePolicy.Fixed)
            except Exception:
                pass
        tag_layout.addWidget(self.feeds_stats_label)

        tag_vlayout.addWidget(top_row)

        self.feed_advanced_filter_input = HistoryDropdown(
            tag_box,
            history_key='feeds_advanced_filter_history',
            placeholder=_('Advanced: type:atom encoding:utf-8 not:img ...'),
            max_items=30,
            min_entry_length=1,
        )
        try:
            self.feed_advanced_filter_input.setClearButtonEnabled(True)
        except Exception:
            pass
        try:
            self.feed_advanced_filter_input.setMinimumWidth(0)
            try:
                self.feed_advanced_filter_input.setSizePolicy(QSizePolicy.Policy.Ignored, QSizePolicy.Policy.Fixed)
            except Exception:
                pass
        except Exception:
            pass
        try:
            help_text = (
                'Advanced feed search (AND):\n'
                '  - tag:NAME  (feeds with tag NAME)\n'
                '  - not:tag:NAME or not:NAME  (feeds without tag NAME)\n'
                '  - type:ATOM / encoding:UTF-8 / version:2.0  (feed specs from last fetch)\n'
                '  - not:type:ATOM / not:encoding:UTF-8 / not:version:2.0\n'
                '  - Built-ins: img, audio, long, updates-frequently (alias: updates_frequently)\n'
                '  - Combine terms with spaces: tag:foo not type:atom not:img'
            )
            self.feed_advanced_filter_input.setToolTip(help_text)
        except Exception:
            pass
        tag_vlayout.addWidget(self.feed_advanced_filter_input)
        self.feed_advanced_filter_input.editTextChanged.connect(
            lambda _t=None: (self._apply_feeds_tag_filter(getattr(self, '_active_feed_tag', None)), self._update_feeds_label())
        )

        left_layout.addWidget(tag_box)
    except Exception:
        pass

    return left_panel
