__license__   = 'GPL v3'
__copyright__ = '2026, Comfy.n'
__docformat__ = 'restructuredtext en'

try:
    load_translations()
except NameError:
    pass

from qt.core import QDialog, QDialogButtonBox, QVBoxLayout, QLabel, QLineEdit, QTextEdit, QHBoxLayout, QPushButton
try:
    from qt.core import QSpinBox
except Exception:
    from PyQt5.Qt import QSpinBox

try:
    from calibre_plugins.rss_reader.config import plugin_prefs
except Exception:
    try:
        from config import plugin_prefs
    except Exception:
        plugin_prefs = {}


class AddMultipleFeedsDialog(QDialog):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.setWindowTitle(_('Add multiple feeds'))
        layout = QVBoxLayout(self)

        layout.addWidget(QLabel(_('Paste one feed URL per line:'), self))
        self.text_edit = QTextEdit(self)
        layout.addWidget(self.text_edit)

        layout.addWidget(QLabel(_('Optional: New folder name for these feeds:'), self))
        self.folder_edit = QLineEdit(self)
        layout.addWidget(self.folder_edit)

        # Oldest article (days) and max articles for the batch
        self.oldest_days_lbl = QLabel(_('Oldest article (days, 0 = no limit):'), self)
        self.oldest_days_spin = QSpinBox(self)
        try:
            self.oldest_days_spin.setRange(0, 36500)
            try:
                d = int(plugin_prefs.get('default_oldest_article_days', 7) or 7)
            except Exception:
                d = 7
            self.oldest_days_spin.setValue(max(0, int(d)))
        except Exception:
            pass
        layout.addWidget(self.oldest_days_lbl)
        layout.addWidget(self.oldest_days_spin)

        self.max_articles_lbl = QLabel(_('Max. number of articles (0 = no limit):'), self)
        self.max_articles_spin = QSpinBox(self)
        try:
            self.max_articles_spin.setRange(0, 100000)
            try:
                m = int(plugin_prefs.get('default_max_articles', 100) or 100)
            except Exception:
                m = 100
            self.max_articles_spin.setValue(max(0, int(m)))
        except Exception:
            pass
        layout.addWidget(self.max_articles_lbl)
        layout.addWidget(self.max_articles_spin)

        btns = QDialogButtonBox(QDialogButtonBox.Ok | QDialogButtonBox.Cancel, self)
        btns.accepted.connect(self.accept)
        btns.rejected.connect(self.reject)
        layout.addWidget(btns)

    def get_values(self):
        urls = [line.strip() for line in self.text_edit.toPlainText().splitlines() if line.strip()]
        folder = self.folder_edit.text().strip()
        try:
            oldest_days = int(getattr(self, 'oldest_days_spin', None).value() or 0)
        except Exception:
            oldest_days = 0
        try:
            max_articles = int(getattr(self, 'max_articles_spin', None).value() or 0)
        except Exception:
            max_articles = 0
        return urls, folder, oldest_days, max_articles
