__license__   = 'GPL v3'
__copyright__ = '2026, Comfy.n'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase
try:
    from calibre.gui2 import must_use_qt
except Exception:
    must_use_qt = None

# pulls in translation files for _() strings
try:
    load_translations()
except NameError:
    pass

try:
    from calibre_plugins.rss_reader.i18n import apply_language_overrides as _apply_language_overrides
    _apply_language_overrides(globals())
except Exception:
    pass

class RSSReaderPlugin(InterfaceActionBase):
    name = 'RSS Reader'
    description = _('Read RSS/Atom feeds inside calibre')
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Comfy.n'
    version = (2, 0, 0)
    minimum_calibre_version = (5, 44, 0)
    actual_plugin = 'calibre_plugins.rss_reader.action:RSSReaderAction'

    def is_customizable(self):
        return True

    def config_widget(self):
        # calibre.gui2.must_use_qt() validates we're on the GUI thread.
        # It is not a context manager in current calibre.
        try:
            if must_use_qt is not None:
                must_use_qt()
        except Exception:
            pass
        gui = getattr(self, 'gui', None)
        if gui is None:
            gui = getattr(getattr(self, 'actual_plugin_', None), 'gui', None)
        if gui is None:
            try:
                from calibre.gui2.ui import get_gui
                gui = get_gui()
            except Exception:
                gui = None

        from calibre_plugins.rss_reader.config import ConfigDialog
        # calibre embeds the returned widget in its own dialog with OK/Cancel.
        # Use embed mode to avoid rendering a second button box.
        return ConfigDialog(gui, embed=True)

    def save_settings(self, config_widget):
        config_widget.save_settings()
        if self.actual_plugin_ is not None:
            try:
                self.actual_plugin_.apply_settings()
            except Exception:
                pass
