#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__   = 'GPL v3'
__copyright__ = '2026, Comfy.n'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase

class ThemeTogglePlugin(InterfaceActionBase):
    name = 'Toggle Light & Dark'
    description = 'Add toolbar button to toggle between light and dark themes'
    supported_platforms = ['windows', 'osx', 'linux']
    author = 'Comfy.n'
    version = (1, 0, 0)
    minimum_calibre_version = (7, 5, 0)
    actual_plugin = 'calibre_plugins.toggle_light_dark.ui:ThemeToggleAction'