# -*- coding: utf-8 -*-

__license__ = 'GPL v3'
__copyright__ = '2025, Comfy.n'
__docformat__ = 'restructuredtext en'

import os
from calibre.utils.logging import default_log as debug_print

# Keep legacy imports stable for modules that import from utils.
# Icon handling lives in common_icons to avoid Calibre-version-specific APIs here.
from calibre_plugins.opf_helper.common_icons import get_icon  # noqa: F401

def is_dark_theme():
    """Check if Calibre is using dark theme"""
    from calibre.gui2 import is_dark_theme as calibre_is_dark
    try:
        return calibre_is_dark()
    except:
        return False