#!/usr/bin/env python
# Debug flag and debug print for all kindleunpackcore modules
DEBUG_KINDLEUNPACKCORE = False
def debug_print(*args, **kwargs):
	if not DEBUG_KINDLEUNPACKCORE:
		return
	print('[kindleunpackcore]', *args, **kwargs)

# Allow main plugin to set debug flag or override debug_print
def set_debug(flag_or_func):
	global DEBUG_KINDLEUNPACKCORE, debug_print
	if callable(flag_or_func):
		debug_print = flag_or_func
	else:
		DEBUG_KINDLEUNPACKCORE = bool(flag_or_func)
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
