from qt.core import (Qt, QWidget, QVBoxLayout, QLabel, QComboBox,
                     QSpinBox, QSlider, QPushButton, QHBoxLayout)
from calibre.utils.logging import default_log as log


# ───────────── Interface de configuration ─────────────
class ConfigWidget(QWidget):
    def __init__(self, options):
        super().__init__()
        self.options = options or {}
        log.info("[PDFtoCBZ] Initialisation ConfigWidget")

        layout = QVBoxLayout(self)

        # Format
        layout.addWidget(QLabel("Format :"))
        self.format_var = QComboBox()
        self.format_var.addItems(["png", "jpg"])
        self.format_var.setCurrentText(str(self.options.get("output_format", "jpg")))
        layout.addWidget(self.format_var)

        # size
        layout.addWidget(QLabel("preferred dimension :"))
        self.dimension_var = QComboBox()
        self.dimension_var.addItems(["manga : 14x21 cm", "comic : 17x26 cm", "Fr_Be : 24x32 cm"])
        self.dimension_var.setCurrentText(str(self.options.get("dimension", "comic : 17x26 cm")))
        layout.addWidget(self.dimension_var)

        # DPI
        #layout.addWidget(QLabel("Resolution (DPI) (in future version):"))
        self.dpi_var = QSpinBox()
        self.dpi_var.setRange(50, 600)
        self.dpi_var.setValue(int(self.options.get("dpi", 200)))
        #layout.addWidget(self.dpi_var)

        # --- Compression ---
        layout.addWidget(QLabel("Compression (0 = compression max, 100 = quality max) :"))
        comp_layout = QHBoxLayout()         # Crée un petit sous-layout horizontal pour le slider + la valeur
        self.comp_var = QSlider(Qt.Horizontal)
        self.comp_var.setRange(0, 100)
        self.comp_var.setValue(int(self.options.get("compression", 95)))
        self.comp_label = QLabel(str(self.comp_var.value()))         # Label de valeur
        self.comp_label.setFixedWidth(30)  # largeur fixe pour alignement propre
        # Connecte le signal du slider à une fonction de mise à jour
        self.comp_var.valueChanged.connect(lambda v: self.comp_label.setText(str(v)))
        # Ajout dans le sous-layout
        comp_layout.addWidget(self.comp_var)
        comp_layout.addWidget(self.comp_label)
        # Ajout du sous-layout au layout principal
        layout.addLayout(comp_layout)

        # methode de conversion
        layout.addWidget(QLabel("method :"))
        self.method_var = QComboBox()
        self.method_var.addItems(["1-in order", "2-in Parallel", "3-in task"])
        self.method_var.setCurrentText(str(self.options.get("method", "1-in order")))
        layout.addWidget(self.method_var)
        self.setLayout(layout)
        log.info("[PDFtoCBZ] ConfigWidget prêt")
